package doABC.Multiname;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import doABC.CpoolInfo;
import FlashReader.SWF;
import FlashReader.SwfTools;

public class MultinameKindMultinameL extends SwfTools{

	private CpoolInfo cpool;
	
	private int start;
	private int end;
	//struktury
	private int ns_set=-1;
	
	
	public MultinameKindMultinameL(CpoolInfo cpool, int ns_set){
		super();
		this.cpool = cpool;
		this.ns_set = ns_set;
	}

	
	public MultinameKindMultinameL(ByteBuffer bbuf,CpoolInfo cpool){
		super();
		this.cpool = cpool;
		multiname_kind_MultinameL(bbuf);
	}
	
	
	private void  multiname_kind_MultinameL(ByteBuffer bbuf){
		
		start = bbuf.position();

		ns_set = 	unsigned30int(bbuf);
		
		end = bbuf.position()-1;
	
	
		
	}


	public int getStart() {
		return start;
	}


	public int getEnd() {
		return end;
	}

	
	public int getNs_set() {
		return ns_set;
	}
	
	public ArrayList<String> getNs_set_string() {
		if ( ns_set ==0)
			return null;
		return cpool.getNsset().get(ns_set).getNs_string();
	}
	
	
	public String String(){
		String wynik ="";
		wynik+="\n---#--- option_info "+SWF.msgs.getString("Position")+": " + start + "\n\n";
		
		wynik+= "ns_set: " + getNs_set_string()+"\n";
			
		wynik+="\n---!!--- "+SWF.msgs.getString("Position")+":  "+end;
		
		return wynik;
		
		
	}
	
	
	public String toString(){
		String wynik ="";
		
		wynik += getNs_set_string();

		return wynik;
	}

	

	public ArrayList<Byte> toByteCode(){
		ArrayList<Byte> result = new ArrayList<Byte>();
		
		if (  ns_set!=-1){
			ArrayList<Byte> tmp =getUI32(ns_set);
			for (int i=0;i<tmp.size();i++)
				result.add(tmp.get(i));
		}
		
		
		return result;
	}
	
	
	
	
	
}
